// Copyright (C) 2005 Peder Holt
// Use, modification and distribution is subject to the Boost Software
// License, Version 1.0. (http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_METAMATH_DOUBLE_EXP_HPP
#define BOOST_METAMATH_DOUBLE_EXP_HPP

#include <boost/metamath/double.hpp>
#include <boost/metamath/double/times.hpp>
#include <boost/metamath/double/divides.hpp>
#include <boost/metamath/double/plus.hpp>
#include <boost/metamath/double/minus.hpp>
#include <boost/metamath/double/constants.hpp>

#include <boost/mpl/if.hpp>
#include <boost/mpl/eval_if.hpp>
#include <boost/mpl/int.hpp>
#include <boost/metamath/double/equal_to.hpp>

namespace boost { namespace metamath {
    namespace detail {
        /*
         * Compile-time Taylor series.
         */
        template <
            typename Arg
          , typename I
          , typename SeriesCount
        >
        struct exp_series
        {
         private:
             typedef typename mpl::eval_if<
                                 mpl::equal_to<mpl::plus<mpl::int_<1>,I>,SeriesCount>
                               , meta::one
                               , exp_series<Arg,mpl::plus<mpl::int_<1>,I>,SeriesCount>
                             >::type
                    next_term;

         public:
            typedef plus_double_double<
                    meta::one,
                    times_double_double<
                        divides_double_double<Arg,integral_to_double<I> >,
                        next_term> > type;
        };

    }  // namespace detail

    template<typename Arg>
    struct exp_double :
      detail::exp_series<Arg,mpl::int_<1>,mpl::int_<14> >
    {
    };

    template<typename Tag>
    struct exp_impl;

    template <>
    struct exp_impl<double_c_tag>
    {
        template<typename Arg>
        struct apply : detail::round<detail::exp_series<Arg,mpl::int_<1>,mpl::int_<14> > >::type
        {
        };
    };

    template <>
    struct exp_impl<mpl::integral_c_tag>
    {
        template<typename Arg>
        struct apply : detail::round<detail::exp_series<integral_to_double<Arg>,mpl::int_<1>,mpl::int_<14> > >::type
        {
        };
    };

}}  //namespace boost::metamath

#endif // BOOST_METAMATH_DOUBLE_EXP_HPP
