//Tuning constants
//Sets the minimum number of items per bin.  Tune this to the processor you're using
static const unsigned LOG_MEAN_BIN_SIZE = 6;
//This should be tuned to your processor cache; if you go too large you get cache misses on bins
//The smaller this number, the less worst-case memory usage.  If too small, too many recursions slow down Spreadsort
static const unsigned MAX_SPLITS = 20;
//Used to force a comparison-based sorting for small bins, if it's faster.  Minimum value 0
static const unsigned LOG_MIN_SPLIT_COUNT = 8;
//There is a minimum size below which it is not worth using Spreadsort
static const unsigned MIN_SORT_SIZE = 8192;
//This is the constant on the log base n of m calculation; make this larger the faster std::sort is relative to spreadsort
static const unsigned LOG_CONST = 3;
