#include <stdio.h>
#include "stdlib.h"

int main(int argc, const char ** argv) {
	//Always seed with the same value, to get the same results
	srand(1);
	//defaults
	unsigned shift1 = 16;
	unsigned shift2 = 16;
	unsigned count = 1000000;
	//Reading in user arguments
	if(argc > 1)
		shift1 = atoi(argv[1]);
	if(argc > 2)
		shift2 = atoi(argv[2]);
	if(argc > 3)
		count = atoi(argv[3]);
	if(shift1 > 16)
		shift1 = 16;
	if(shift2 > 16)
		shift2 = 16;
	FILE * pFile;
	pFile=fopen("input.txt","w");
	//buffering file output for speed
	unsigned uDivideFactor = 1000;
	//Skipping buffering for small files
	if(count < uDivideFactor * 100)
		uDivideFactor = count;
	unsigned * pNumbers = (unsigned *) malloc(uDivideFactor * sizeof(unsigned));
	//Generating semirandom numbers
	for(unsigned u = 0; u < count/uDivideFactor; ++u) {
		unsigned i = 0;
		for(; i< uDivideFactor; i++) {
			//assumes that unsigned are 4 bytes and unsigned shorts are 2 bytes
			unsigned short * ptr = (unsigned short *)(pNumbers + i);
			ptr[0]=rand() % (1 << shift1);
			ptr[1]=rand() % (1 << shift2);
		}
		fwrite(pNumbers, uDivideFactor, 4, pFile);
	}
	return 0;
}
