#include "SpreadSort.h"
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <algorithm>
#include <vector.h>

	struct DATATYPE {
		int latitude;
		int longitude;
		char * name;
		inline long operator>>(const unsigned offset) const {
			return latitude >> offset;
		}
		inline bool operator<(const DATATYPE & rhs) const{
			return latitude < rhs.latitude;
		}
	};

//Pass in an argument to test std::sort
int main(int argc, const char ** argv) {
	FILE * pInputFile,*pOutputFile;
	bool stdSort = false;
	unsigned loopCount = 1;
	for(int u = 1; u < argc; ++u) {
		if(!strcmp(argv[u], "-std"))
			stdSort = true;
		else
			loopCount = atoi(argv[u]);
	}
	pInputFile=fopen("input.txt","r");	
	if(!pInputFile) {
		printf("c:\\input.txt could not be opened\n");
		return 1;
	}
	double total = 0.0;
	vector<DATATYPE> array, temp;
	//Run multiple loops, if requested
	for(unsigned u = 0; u < loopCount; ++u) {
		DATATYPE latest;
		char buf[256];
		while(feof(pInputFile)== 0) {
			fscanf(pInputFile, "%f %f %[^\n]\n", (float *)&(latest.latitude), (float *)&(latest.longitude), buf);
			latest.name = strdup(buf);
			temp.push_back(latest);
		}
		swap(temp, array);
		clock_t start, end;
		double elapsed;
		start = clock();
		if(stdSort)
			std::sort(array.begin(), array.end());
		else
			integer_sort(&(array[0]), array.size());
		end = clock();
		elapsed = ((double) (end - start)) ;
		if(stdSort)
			pOutputFile=fopen("StandardSortOut.txt","w");
		else
			pOutputFile=fopen("SpreadSortOut.txt","w");
		if(pOutputFile) {
			for(unsigned u = 0; u < array.size(); ++u)
				fprintf(pOutputFile, "%d\n", array[u].latitude);
				//fprintf(pOutputFile, "%d %d %s\n", array[u].latitude, array[u].longitude, array[u].name);
			fclose(pOutputFile);
		}
		total += elapsed;
		array.clear();
	}
	if(stdSort)
		printf("std::sort elapsed time %f\n", total / CLOCKS_PER_SEC);
	else
		printf("Spreadsort elapsed time %f\n", total / CLOCKS_PER_SEC);
	return 0;
}
